% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ici.R
\name{ici}
\alias{ici}
\title{Integral Condition Index}
\usage{
ici(
  data,
  format = c("m", "c"),
  ue = 1,
  esc = NULL,
  nc = 2,
  console = T,
  radar = T
)
}
\arguments{
\item{data}{Excel book with its extension.}

\item{format}{type of format: m (marks by default) or c (calificaciones (scores)).}

\item{ue}{Unidad de evaluación.}

\item{esc}{Scaling.}

\item{nc}{Number of constructs.}

\item{console}{Show results on console (def. TRUE).}

\item{radar}{Draws a radar chart (def. TRUE).}
}
\value{
Calculate the ICI and the itermediate indexes over one or several evaluation units.
}
\description{
Calculates condition indexes over some evaluation units.
}
\examples{
# NOTICE: Given that Excel files are not R objects, but external files, they cannot be
# loaded into memory when ici package is attached. So, in order to run examples
# you must make Excel files available by locating them on your working directory path.
# You can find Excel files in the 'extdata/' directory within the installed package
# on your local drive. You can also download them through the book:
# https://bookdown.org/gcorrea/ICI/ICIresources.rar.
#
# Example 1a: Marks format (default), 2 evaluation units
ici("Eje1m.xlsx", ue = 2)

# Example 1b: Scores format, 2 evaluation units, scaling between 0 and 100
ici("Eje1c.xlsx", "c", ue = 2, esc = c(1, 5, 0, 100))

# Example 1c: Marks format with missing values
ici("Eje1mf.xlsx", ue = 2)

#' # Example 1d: Scores format with missing values
ici("Eje1cf.xlsx", "c", ue = 2)

# Example 2a: 2 evaluation units, 4 constructs, scaling between 0 and 100
#             Marks format
ici("Eje2m.xlsx", ue = 2, esc = c(1, 5, 0, 100), nc = 4)

# Example 2b: 2 evaluation units, 4 constructs, scaling between 0 and 100
#             Scores format
ici("Eje2c.xlsx", format = "c", ue = 2, esc = c(1, 5, 0, 100), nc = 4)
}
\references{
Correa-Londoño, G. (2023). Índice de Condición Integral. https://bookdown.org/gcorrea/ICI/.
}
\seealso{
\link{ici_escal} for consensuating and scaling the category scores of a variable,
and \link{ici_pond} for consensuating and scaling the weights of some variables on a complex construct.
}
\author{
Guillermo Correa (gcorrea@unal.edu.co)
}
